/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.catalogos.ComprobantesReembolso;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresCompReembolso;
import ec.gob.sri.dimm.ats.modelo.obj.compras.Reembolso;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ValoresComprobanteReembolso;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wb.swt.SWTResourceManager;

public class DialogoReembolso
extends DialogoBase
implements VistaModelo<Reembolso>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private ModeloValoresCompReembolso modeloValores;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private Reembolso modeloDatos;
    private Text txtIvaCero;
    private Text txtIvaNoCero;
    private Text txtMontoIva;
    private Combo combo;
    private ComboViewer cvTipoComprobante;
    private Text txtICE;
    private Text txtIdProveedor;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtNumSerie;
    private Text txtAutorizacion;
    private ComboViewer cvIdProveedor;
    private Text txtNoIva;
    private boolean datosNoCargados = true;
    private List<Reembolso> reembolsosExistentes;
    private boolean editando = false;
    private Reembolso reembolsoActual = new Reembolso();
    private Text txtBaseExcenta;
    private final BigDecimal valorAcumuladoReembolsos;
    private BigDecimal sumaBasesImponiblesReembolsoEditado;
    private final Periodo periodo;

    public DialogoReembolso(IWorkbenchPartSite site, List<Reembolso> reembolsosExistentes, BigDecimal valorAcumuladoReembolsos, Periodo periodo, boolean editando) {
        super(site);
        this.valorAcumuladoReembolsos = valorAcumuladoReembolsos;
        this.periodo = periodo;
        this.setShellStyle(80);
        this.reembolsosExistentes = reembolsosExistentes;
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresCompReembolso();
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(Reembolso modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.sumaBasesImponiblesReembolsoEditado = Util.sumarValores((String[])new String[]{modeloDatos.getValoresComprobanteReembolso().getBaseIvaCero(), modeloDatos.getValoresComprobanteReembolso().getBaseNoIvaReemb(), modeloDatos.getValoresComprobanteReembolso().getBaseIvaNoCeroReembolso(), modeloDatos.getValoresComprobanteReembolso().getBaseImponibleExcentaIva()});
            this.reembolsoActual.setEstablecimiento(modeloDatos.getEstablecimiento());
            this.reembolsoActual.setNumAutorizacion(modeloDatos.getNumAutorizacion());
            this.reembolsoActual.setPuntoEmision(modeloDatos.getPuntoEmision());
            this.reembolsoActual.setSecuencial(modeloDatos.getSecuencial());
            this.reembolsoActual.getProveedor().setTipoIdentificacion(modeloDatos.getProveedor().getTipoIdentificacion());
            this.reembolsoActual.getProveedor().setIdentificacion(modeloDatos.getProveedor().getIdentificacion());
            this.reembolsoActual.setTipoComprobanteReembolso(modeloDatos.getTipoComprobanteReembolso());
        }
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoIdentificacion = this.modeloDatos.getProveedor().getTipoIdentificacion();
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codigoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvIdProveedor, (Object)tipoIdentificacion);
        if (this.datosNoCargados && codigoIdentificacion != null) {
            this.modeloValores.cargarTiposDeComprobantes(codigoIdentificacion);
            this.cvTipoComprobante.refresh();
        }
        String codigoTipoComprobante = this.modeloDatos.getTipoComprobanteReembolso();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codigoTipoComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoComprobante, (Object)tipoComprobante);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoReembolso.this.modeloDatos.equals((Object)DialogoReembolso.this.reembolsoActual)) {
                    Reembolso reembolsoTemporal = new Reembolso();
                    reembolsoTemporal.setEstablecimiento(DialogoReembolso.this.modeloDatos.getEstablecimiento());
                    reembolsoTemporal.setNumAutorizacion(DialogoReembolso.this.modeloDatos.getNumAutorizacion());
                    reembolsoTemporal.setPuntoEmision(DialogoReembolso.this.modeloDatos.getPuntoEmision());
                    reembolsoTemporal.setSecuencial(DialogoReembolso.this.modeloDatos.getSecuencial());
                    reembolsoTemporal.getProveedor().setTipoIdentificacion(DialogoReembolso.this.modeloDatos.getProveedor().getTipoIdentificacion());
                    reembolsoTemporal.getProveedor().setIdentificacion(DialogoReembolso.this.modeloDatos.getProveedor().getIdentificacion());
                    reembolsoTemporal.setTipoComprobanteReembolso(DialogoReembolso.this.modeloDatos.getTipoComprobanteReembolso());
                    if (DialogoReembolso.this.reembolsosExistentes.contains(reembolsoTemporal)) {
                        resultado.fallarValidacion("El Reembolso ya se encuentra registrado");
                    }
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getProveedor().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getValoresComprobanteReembolso().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.datosNoCargados = false;
    }

    protected void okPressed() {
        if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            if (this.validarSumaDeBasesImponiblesConElComprobante()) {
                super.okPressed();
            } else {
                this.setErrorMessage(String.format("La sumatoria Total de bases Imponibles Reembolsos no puede exceder la sumatoria de bases del comprobante %s asociado al reembolso", this.calcularSumaBasesComprobante()));
            }
        } else {
            super.okPressed();
        }
    }

    private boolean validarSumaDeBasesImponiblesConElComprobante() {
        BigDecimal sumaBasesImponiblesComprobante = this.calcularSumaBasesComprobante();
        ValoresComprobanteReembolso valoresComprobanteReembolso = this.modeloDatos.getValoresComprobanteReembolso();
        BigDecimal sumaBasesImponiblesReembolsoActual = Util.sumarValores((String[])new String[]{valoresComprobanteReembolso.getBaseIvaCero(), valoresComprobanteReembolso.getBaseIvaNoCeroReembolso(), valoresComprobanteReembolso.getBaseNoIvaReemb(), valoresComprobanteReembolso.getBaseImponibleExcentaIva()});
        BigDecimal totalAcumuladoReembolsos = this.valorAcumuladoReembolsos.add(this.calcularAcumuladoDeReembolsosPorTipoDeComprobante(sumaBasesImponiblesReembolsoActual));
        if (this.editando) {
            totalAcumuladoReembolsos = totalAcumuladoReembolsos.subtract(this.sumaBasesImponiblesReembolsoEditado);
        }
        return sumaBasesImponiblesComprobante.compareTo(totalAcumuladoReembolsos) >= 0;
    }

    private BigDecimal calcularSumaBasesComprobante() {
        this.modeloDatos.getCompraSeleccionada().getValoresComprovanteVenta().calcularSumaBasesImponibles();
        return this.modeloDatos.getCompraSeleccionada().getValoresComprovanteVenta().getSumaBasesImponibles();
    }

    private BigDecimal calcularAcumuladoDeReembolsosPorTipoDeComprobante(BigDecimal sumaBasesImponiblesReembolsoActual) {
        if (ComprobantesReembolso.codigosComprobantesReembolsoResta.containsKey(this.modeloDatos.getTipoComprobanteReembolso())) {
            sumaBasesImponiblesReembolsoActual = sumaBasesImponiblesReembolsoActual.negate();
        }
        return sumaBasesImponiblesReembolsoActual;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n del comprobante de reembolso");
        this.setTitle("Comprobante de Reembolso");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setText("Tipo Id. Proveedor");
        this.cvIdProveedor = new ComboViewer(container, 8);
        this.cvIdProveedor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                if (DialogoReembolso.this.datosNoCargados) {
                    return;
                }
                ElementoNombreValor tipoIdentificacion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoIdentificacion != null) {
                    DialogoReembolso.this.modeloDatos.setTipoComprobanteReembolso(null);
                    DialogoReembolso.this.modeloDatos.getProveedor().setTipoIdentificacion((String)tipoIdentificacion.getValor());
                    DialogoReembolso.this.modeloDatos.getProveedor().setDescripcionTipoIdentificacion(tipoIdentificacion.getNombre());
                    DialogoReembolso.this.modeloValores.cargarTiposDeComprobantes(DialogoReembolso.this.modeloDatos.getProveedor().getTipoIdentificacion());
                    AyudanteViewer.seleccionarElemento((Viewer)DialogoReembolso.this.cvTipoComprobante, null);
                    DialogoReembolso.this.cvTipoComprobante.refresh();
                }
            }
        });
        Combo combo_1 = this.cvIdProveedor.getCombo();
        GridData gd_combo_1 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_1.widthHint = 125;
        combo_1.setLayoutData((Object)gd_combo_1);
        Label lblIdentificacionProveedor = new Label(container, 0);
        GridData gd_lblIdentificacionProveedor = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblIdentificacionProveedor.widthHint = 130;
        lblIdentificacionProveedor.setLayoutData((Object)gd_lblIdentificacionProveedor);
        lblIdentificacionProveedor.setText("Identificacion Proveedor");
        this.txtIdProveedor = new Text(container, 2048);
        this.txtIdProveedor.setTextLimit(13);
        GridData gd_txtIdProveedor = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdProveedor.widthHint = 100;
        this.txtIdProveedor.setLayoutData((Object)gd_txtIdProveedor);
        Label lblTipoDeComprobante = new Label(container, 0);
        GridData gd_lblTipoDeComprobante = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoDeComprobante.widthHint = 125;
        lblTipoDeComprobante.setLayoutData((Object)gd_lblTipoDeComprobante);
        lblTipoDeComprobante.setText("Tipo de Comprobante");
        this.cvTipoComprobante = new ComboViewer(container, 8);
        this.cvTipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoComprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoComprobante != null) {
                    DialogoReembolso.this.modeloDatos.setTipoComprobanteReembolso((String)tipoComprobante.getValor());
                    DialogoReembolso.this.modeloDatos.setDescripcionTipoComprobanteReembolso(tipoComprobante.getNombre());
                }
            }
        });
        this.combo = this.cvTipoComprobante.getCombo();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        this.combo.setLayoutData((Object)gd_combo);
        new Label(container, 0);
        Composite composite_1 = new Composite(container, 0);
        GridLayout gl_composite_1 = new GridLayout(3, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        Label label = new Label(composite_1, 0);
        label.setText("Establecimiento");
        Label label_1 = new Label(composite_1, 0);
        label_1.setText("Punto de Emisi\u00f3n");
        Label lblSecuencial = new Label(composite_1, 0);
        lblSecuencial.setText("Secuencial");
        this.txtEstablecimiento = new Text(composite_1, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        this.txtEstablecimiento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPuntoEmision = new Text(composite_1, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        this.txtPuntoEmision.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtNumSerie = new Text(composite_1, 2048);
        this.txtNumSerie.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtNumSerie.selectAll();
            }
        });
        this.txtNumSerie.setTextLimit(9);
        GridData gd_txtNumSerie = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtNumSerie.widthHint = 100;
        this.txtNumSerie.setLayoutData((Object)gd_txtNumSerie);
        Label label_3 = new Label(container, 0);
        GridData gd_label_3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_label_3.widthHint = 130;
        label_3.setLayoutData((Object)gd_label_3);
        label_3.setText("N\u00b0 Autorizaci\u00f3n");
        this.txtAutorizacion = new Text(container, 2048);
        this.txtAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtAutorizacion.selectAll();
            }
        });
        this.txtAutorizacion.setTextLimit(49);
        GridData gd_txtAutorizacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtAutorizacion.widthHint = 150;
        this.txtAutorizacion.setLayoutData((Object)gd_txtAutorizacion);
        Label lblFechaEmisin = new Label(container, 0);
        lblFechaEmisin.setText("Fecha Emisi\u00f3n");
        final CDateTime dtFechaEmision = new CDateTime(container, 32771);
        dtFechaEmision.setPattern("dd/MM/yyyy");
        dtFechaEmision.setNullText("seleccione la fecha");
        GridData gd_dtFechaEmision = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dtFechaEmision.widthHint = 125;
        dtFechaEmision.setLayoutData((Object)gd_dtFechaEmision);
        dtFechaEmision.setSelection(this.modeloDatos.getFechaEmision());
        dtFechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogoReembolso.this.modeloDatos.setFechaEmision(dtFechaEmision.getSelection());
            }
        });
        Label lblBasesImponibles = new Label(container, 0);
        GridData gd_lblBasesImponibles = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblBasesImponibles.verticalIndent = 10;
        lblBasesImponibles.setLayoutData((Object)gd_lblBasesImponibles);
        lblBasesImponibles.setFont(SWTResourceManager.getBoldFont((Font)lblBasesImponibles.getFont()));
        lblBasesImponibles.setText("Bases Imponibles");
        new Label(container, 0);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label lblTarifaIva = new Label(composite, 0);
        lblTarifaIva.setText("Tarifa IVA 0%");
        this.txtIvaCero = new Text(composite, 2048);
        this.txtIvaCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtIvaCero.selectAll();
            }
        });
        this.txtIvaCero.setTextLimit(15);
        GridData gd_txtIvaCero = new GridData(16384, 128, false, false, 1, 1);
        gd_txtIvaCero.widthHint = 100;
        this.txtIvaCero.setLayoutData((Object)gd_txtIvaCero);
        this.txtIvaCero.setBounds(0, 0, 76, 21);
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblTarifaIvaDiferente = new Label(composite, 0);
        GridData gd_lblTarifaIvaDiferente = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTarifaIvaDiferente.widthHint = 125;
        lblTarifaIvaDiferente.setLayoutData((Object)gd_lblTarifaIvaDiferente);
        lblTarifaIvaDiferente.setText("Tarifa IVA diferente 0%");
        this.txtIvaNoCero = new Text(composite, 2048);
        this.txtIvaNoCero.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DialogoReembolso.this.modeloDatos.getValoresComprobanteReembolso().setModificaIva(false);
            }
        });
        this.txtIvaNoCero.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtIvaNoCero.selectAll();
            }
        });
        this.txtIvaNoCero.setTextLimit(15);
        this.txtIvaNoCero.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblMonto = new Label(composite, 0);
        lblMonto.setAlignment(131072);
        GridData gd_lblMonto = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMonto.widthHint = 100;
        lblMonto.setLayoutData((Object)gd_lblMonto);
        lblMonto.setText(" Monto de IVA");
        this.txtMontoIva = new Text(composite, 2048);
        this.txtMontoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtMontoIva.selectAll();
            }
        });
        this.txtMontoIva.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DialogoReembolso.this.modeloDatos.getValoresComprobanteReembolso().setModificaIva(true);
            }
        });
        this.txtMontoIva.setTextLimit(15);
        GridData gd_txtMontoIva = new GridData(4, 128, true, false, 1, 1);
        gd_txtMontoIva.widthHint = 100;
        this.txtMontoIva.setLayoutData((Object)gd_txtMontoIva);
        Label lblTarifaNoIva = new Label(composite, 0);
        GridData gd_lblTarifaNoIva = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTarifaNoIva.widthHint = 130;
        lblTarifaNoIva.setLayoutData((Object)gd_lblTarifaNoIva);
        lblTarifaNoIva.setText("Tarifa No Objeto de IVA");
        this.txtNoIva = new Text(composite, 2048);
        this.txtNoIva.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtNoIva.selectAll();
            }
        });
        this.txtNoIva.setTextLimit(15);
        GridData gd_txtNoIva = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtNoIva.widthHint = 100;
        this.txtNoIva.setLayoutData((Object)gd_txtNoIva);
        Label lblMontoDeIce = new Label(composite, 0);
        lblMontoDeIce.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMontoDeIce.setText(" Monto de ICE");
        this.txtICE = new Text(composite, 2048);
        this.txtICE.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoReembolso.this.txtICE.selectAll();
            }
        });
        this.txtICE.setTextLimit(15);
        this.txtICE.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblBaseExcentaDe = new Label(composite, 0);
        lblBaseExcentaDe.setText("Base Exenta de IVA");
        this.txtBaseExcenta = new Text(composite, 2048);
        this.txtBaseExcenta.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    protected Point getInitialSize() {
        return new Point(660, 520);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvIdProveedor.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvIdProveedor.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposIdentificacionModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacion").observe((Object)this.modeloValores);
        this.cvIdProveedor.setInput((Object)tiposIdentificacionModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvTipoComprobante.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList tiposDeComprobantesModeloValoresObserveList = PojoProperties.list((String)"tiposDeComprobantes").observe((Object)this.modeloValores);
        this.cvTipoComprobante.setInput((Object)tiposDeComprobantesModeloValoresObserveList);
        ISWTObservableValue observeTextTxtIdProveedorObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIdProveedor);
        IObservableValue proveedoridentificacionModeloDatosObserveValue = BeanProperties.value((String)"proveedor.identificacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIdProveedorObserveWidget, proveedoridentificacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue establecimientoModeloDatosObserveValue = BeanProperties.value((String)"establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, establecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue puntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, puntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumSerieObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumSerie);
        IObservableValue secuencialModeloDatosObserveValue = BeanProperties.value((String)"secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumSerieObserveWidget, secuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtAutorizacion);
        IObservableValue numAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtAutorizacionObserveWidget, numAutorizacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtIvaCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIvaCero);
        IObservableValue valoresComprobanteReembolsobaseIvaCeroModeloDatosObserveValue = BeanProperties.value((String)"valoresComprobanteReembolso.baseIvaCero").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIvaCeroObserveWidget, valoresComprobanteReembolsobaseIvaCeroModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtIvaNoCeroObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIvaNoCero);
        IObservableValue valoresComprobanteReembolsobaseIvaNoCeroModeloDatosObserveValue = BeanProperties.value((String)"valoresComprobanteReembolso.baseIvaNoCeroReembolso").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIvaNoCeroObserveWidget, valoresComprobanteReembolsobaseIvaNoCeroModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoIva);
        IObservableValue valoresComprobanteReembolsomontoIvaModeloDatosObserveValue = BeanProperties.value((String)"valoresComprobanteReembolso.montoIvaReembolso").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoIvaObserveWidget, valoresComprobanteReembolsomontoIvaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtICEObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtICE);
        IObservableValue valoresComprobanteReembolsomontoIceModeloDatosObserveValue = BeanProperties.value((String)"valoresComprobanteReembolso.montoIce").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtICEObserveWidget, valoresComprobanteReembolsomontoIceModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNoIvaObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNoIva);
        IObservableValue valoresComprobanteReembolsobaseNoIvaReembModeloDatosObserveValue = BeanProperties.value((String)"valoresComprobanteReembolso.baseNoIvaReemb").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNoIvaObserveWidget, valoresComprobanteReembolsobaseNoIvaReembModeloDatosObserveValue, null, null);
        ISWTObservableValue txtBaseExcentaObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtBaseExcenta, (int)24);
        IObservableValue modeloDatosValoresComprobanteReembolsobaseImponibleExcentaIvaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"valoresComprobanteReembolso.baseImponibleExcentaIva");
        bindingContext.bindValue((IObservableValue)txtBaseExcentaObserveTextObserveWidget, modeloDatosValoresComprobanteReembolsobaseImponibleExcentaIvaObserveValue, null, null);
        return bindingContext;
    }
}

